﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using Vimt.HealthShare.Messages.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get the Make/Cancel Outbound EC Request Message.
    /// </summary>
    public class GetOutboundEcRequestMessageStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            try
            {
                var ecRequestMessageString = state.IntegrationResult.mcs_vimtrequest;
                if (string.IsNullOrEmpty(ecRequestMessageString)) throw new Exception($"The Vimt Request cannot be null or empty for Integration Result {state.IntegrationResult.Id}");

                state.OutboundEcRequestMessage = PipelineUtilities.Deserialize<VimtHealthShareMakeCancelOutboundRequestMessage>(ecRequestMessageString);
            }
            catch (Exception ex)
            {
                Logger.Instance.Error($"ERROR: HealthShare Make Cancel Inbound Get Outbound EC Request Message Pipeline Error: {ex.Message}", ex.InnerException);
                throw new Exception($"HealthShare Make Cancel Inbound Get Outbound EC Request Message Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}